<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Customer form</title>
  <meta name="description" content="">
  <meta name="keywords" content="">

  <!-- Favicons -->
  <!--<link href="assets/img/favicon.png" rel="icon">-->
  <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;1,300;1,400;1,500;1,600;1,700;1,800&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Jost:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="{{ asset('assets/vendor/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">
  <link href="{{ asset('assets/vendor/bootstrap-icons/bootstrap-icons.css') }}" rel="stylesheet">
  <link href="{{ asset('assets/vendor/aos/aos.css') }}" rel=" stylesheet">
  <link href="{{ asset('assets/vendor/glightbox/css/glightbox.min.css') }}" rel="stylesheet">
  <link href="{{ asset('assets/vendor/swiper/swiper-bundle.min.css') }}" rel="stylesheet">
  <!-- Font Awesome Free 6 CDN -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">


  <!-- Main CSS File -->
  <link href="{{ asset('assets/css/main.css') }}" rel="stylesheet">

  <!-- =======================================================
  * Template Name: mytemplate
  * Template URL: https://bootstrapmade.com/arsha-free-bootstrap-html-template-corporate/
  * Updated: Feb 22 2025 with Bootstrap v5.3.3
  * Author: BootstrapMade.com
  * License: https://bootstrapmade.com/license/
  ======================================================== -->
</head>

<body class="login-page">


<main id="mainContent">
    <div class="container login-container">
        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif
        @if(session('error'))
            <div class="alert alert-danger">{{ session('error') }}</div>
        @endif
        <div class="row d-flex justify-content-center">
      
          <!-- Left Side (Form) -->
          <div class="col-md-5 loginCol">
            <div class="col-md-12 login-left">

            <div class="div d-flex justify-content-center">
                <img src="{{ url($imagePath) }}" alt="Restaurant Image" style="max-width: 120px; height: auto;">
            </div>
                <h2>Customer details</h2>

              <form method="post" action="{{ url('/customer') }}">
    @csrf

    <!-- Full Name -->
    <div class="mb-3">
        <label class="form-label">Full Name</label>
        <input type="text" 
               class="form-control" 
               name="name" 
               placeholder="Enter your full name" 
               value="{{ old('name') }}" 
               required>
        <input type="hidden" name="restaurant_id" value="{{ $restaurant_id }}">
        <input type="hidden" name="token" value="{{ $token }}">
        @error('name') <span class="text-danger">{{ $message }}</span>  @enderror
    </div>

    <!-- Email -->
    <div class="mb-3">
        <label class="form-label">Email</label>
        <input type="email" 
               class="form-control" 
               name="email" 
               placeholder="Enter your email" 
               value="{{ old('email') }}" 
               required>
        @error('email') <span class="text-danger">{{ $message }}</span>  @enderror
    </div>

    <!-- Phone Number -->
    <div class="mb-3">
        <label class="form-label">Phone Number</label>
        <input type="tel" 
               class="form-control" 
               name="phone" 
               placeholder="Enter your phone number" 
               value="{{ old('phone') }}" 
               required>
        @error('phone') <span class="text-danger">{{ $message }}</span>  @enderror
    </div>

    <!-- City -->
    <div class="mb-3">
        <label class="form-label">Location</label>
             <select name="location" class="form-control" id="location">
            <!--<option value="">Location</option>-->
            <!--<option value="Lahore" {{ old('location') == 'Lahore' ? 'selected' : '' }}>Lahore</option>-->
            <!--<option value="Karachi" {{ old('location') == 'Karachi' ? 'selected' : '' }}>Karachi</option>-->
            <option value="Charolais Blvd Brampton" {{ old('location') == 'Charolais Blvd Brampton' ? 'selected' : '' }}>Charolais Blvd Brampton</option>
            <option value="James Potter Rd Brampton" {{ old('location') == 'James Potter Rd Brampton' ? 'selected' : '' }}>James Potter Rd Brampton</option>
            <option value="Remembrance Rd Brampton" {{ old('location') == 'Remembrance Rd Brampton' ? 'selected' : '' }}>Remembrance Rd Brampton</option>
            <option value="Light Beam Terrace Brampton" {{ old('location') == 'Light Beam Terrace Brampton' ? 'selected' : '' }}>Light Beam Terrace Brampton</option>
            <option value="Bakery, Charolais Blvd Brampton" {{ old('location') == 'Bakery, Charolais Blvd Brampton' ? 'selected' : '' }}>Bakery, Charolais Blvd Brampton</option>

        </select>
    </div>

    <!-- Privacy Policy -->
    <div class="form-check mb-3">
        <input class="form-check-input" 
               type="checkbox" 
               name="privacy_policy" 
               id="privacy_policy"
               {{ old('privacy_policy') ? 'checked' : '' }}>
        <label class="form-check-label" for="privacy_policy">
            I have read and agree to the <a href="http://launch-pad.ca/doaba-privacy">privacy policy</a>
        </label>
        @error('privacy_policy')
            <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>

    <!-- Terms -->
    <div class="form-check mb-3">
        <input class="form-check-input" 
               type="checkbox" 
               name="terms" 
               id="terms"
               {{ old('terms') ? 'checked' : '' }}>
        <label class="form-check-label" for="terms">
           I have read and agree to <a href="http://launch-pad.ca/doaba-terms">terms and conditions</a>
        </label>
        @error('terms')
            <div class="text-danger">{{ $message }}</div>
        @enderror
    </div>

    <button type="submit" class="btn btn-login w-100 mt-2">Submit</button>
</form>



            </div>
         </div>

        </div>
      </div>


      <!-- Scroll Top -->
  <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Preloader -->
  <div id="preloader"></div>

  <!-- Vendor JS Files -->
  <script src="{{ asset('assets/vendor/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
  <script src="{{ asset('assets/vendor/php-email-form/validate.js') }}"></script>
  <script src="{{ asset('assets/vendor/aos/aos.js') }}"></script>
  <script src="{{ asset('assets/vendor/glightbox/js/glightbox.min.js') }}"></script>
  <script src="{{ asset('assets/vendor/swiper/swiper-bundle.min.js') }}"></script>
  <script src="{{ asset('assets/vendor/waypoints/noframework.waypoints.js') }}"></script>
  <script src="{{ asset('assets/vendor/imagesloaded/imagesloaded.pkgd.min.js') }}"></script>
  <script src="{{ asset('assets/vendor/isotope-layout/isotope.pkgd.min.js') }}"></script>

  <!-- Main JS File -->
  <script src="assets/js/main.js"></script>
</main>
</body>

</html>
