<?php

namespace App\Http\Controllers\Api;

use App\Models\User;
use App\Models\Restaurant;
use App\Models\Customer;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class AuthController extends Controller
{
    public function login(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email',
            'password' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()], 422);
        }

        $user = User::with('restaurant')->where('email', $request->email)->first();
        if (! $user || ! Hash::check($request->password, $user->password)) {
            return response()->json(['message' => 'Invalid credentials'], 401);
        }

        $token = $user->createToken('API Token')->plainTextToken;

        return response()->json([
            'user' => $user,
            'token' => $token
        ]);
    }

    public function logout(Request $request)
    {
        $request->user()->tokens()->delete();
        return response()->json(['message' => 'Logged out successfully']);
    }
    
    public function getCustomer($restaurant_id)
    {
        $size = request('size', 10);
        $page = request('page', 1);
    
        $restaurant = Restaurant::find($restaurant_id);
    
        if (!$restaurant) {
            return response()->json(['error' => "Restaurant Not Found"], 404);
        }
        
        $customersQuery = $restaurant->customer();
    
        if (!$customersQuery->exists()) {
            return response()->json(['customer' => "Customer Not Found"], 404);
        }

        $customers = $customersQuery->orderBy('id', 'DESC')->paginate($size);
    
        $start = ($customers->currentPage() - 1) * $customers->perPage() + 1;
    
        $customers->getCollection()->transform(function ($item) use (&$start) {
            $item->id = $start++;
            return $item;
        });
    
        return response()->json(['customer' => $customers], 200);
    }

    
    
    // public function getCustomer($restaurant_id)
    // {
    //     $restaurant = Restaurant::with('customer')->find($restaurant_id);

    //     if ($restaurant) {
    //         if ($restaurant->customer){
    //             $customers = $restaurant->customer;

    //             // Agar ek se zyada customers hain (collection), numbering set karein
    //             if ($customers instanceof \Illuminate\Support\Collection) {
    //                 $count = 1;
    //                 $customers = $customers->map(function ($item) use (&$count) {
    //                     $item->id = $count++; // override only ID to sequential number
    //                     return $item;
    //                 });
    //             } else {
    //                 // Agar single customer hai (relation one-to-one)
    //                 $customers->id = 1;
    //             }

    //             return response()->json(['customer' => $customers], 200);
    //         } else {
    //             return response()->json(['customer' => "Customer Not Found"], 404);
    //         }
    //     } else {
    //         return response()->json(['error' => "Restaurant Not Found"], 404);
    //     }
    // }
    
    
}
